// Logger.cs
// Ot@C̏o

using System;
using System.IO;
using System.Text;

public static class Logger
{
    private static string _logFileName = "";
    private static string _logExFileName = "";
    private static readonly object _lock = new object();

    public static void Initialize()
    {
        DateTime now = DateTime.Now;
        string dateSuffix = now.ToString("yyMMdd");
        string baseDirectory = AppDomain.CurrentDomain.BaseDirectory;
        
        // o̓fBNg݂Ȃꍇ͍쐬
        Directory.CreateDirectory(baseDirectory);

        _logFileName = Path.Combine(baseDirectory, $"suica_{dateSuffix}.txt");
        _logExFileName = Path.Combine(baseDirectory, $"suica_accesslog_{dateSuffix}.SCB");
    }

    public static void Log(uint code, string message)
    {
        string formattedMessage = $"{code:X4},\"{DateTime.Now:yyyy/MM/dd HH:mm:ss}\",\"0000\", \"{message}\"\n";
        lock (_lock)
        {
            File.AppendAllText(_logFileName, formattedMessage, Encoding.UTF8);
        }
    }

    public static void LogEx(string message)
    {
        string timestamp = DateTime.Now.ToString("yyyy/MM/dd_HH:mm:ss.fff");
        string formattedMessage = $"<{timestamp}> {message}\n";
        lock (_lock)
        {
            File.AppendAllText(_logExFileName, formattedMessage, Encoding.UTF8);
        }
    }
}

// Copyright 2023 OCT Co.,Ltd. All Rights Reserved.
