// CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D 
// SerialCommunicator.cs
// VA|[gʐM̃WbNǗ
// CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D 

using System;
using System.IO.Ports;
using System.Threading;

public class SerialCommunicator : IDisposable
{
    private readonly SerialPort _serialPort;

    public SerialCommunicator()
    {
        _serialPort = new SerialPort();
    }

    public bool Open(string portName)
    {
        try
        {
            _serialPort.PortName = portName;
            _serialPort.BaudRate = 38400;
            _serialPort.DataBits = 8;
            _serialPort.Parity = Parity.None;
            _serialPort.StopBits = StopBits.One;
            _serialPort.Handshake = Handshake.None;
            _serialPort.ReadTimeout = 500;
            _serialPort.WriteTimeout = 500;
            _serialPort.Open();
            return true;
        }
        catch (Exception ex)
        {
            Console.WriteLine($"VA|[g{portName}J܂: {ex.Message}");
            return false;
        }
    }

    public void Close()
    {
        if (_serialPort.IsOpen)
        {
            _serialPort.Close();
        }
    }

    public void Dispose()
    {
        Close();
        _serialPort.Dispose();
    }

    public int MvtTxRx(byte[] txData, byte[] rxData)
    {
        if (!_serialPort.IsOpen) return -1;

        try
        {
            byte[] frameToSend = txData;
            if (txData.Length > 2)
            {
                byte bc = txData[2];
                frameToSend = new byte[txData.Length + 1];
                Array.Copy(txData, frameToSend, txData.Length);
                byte fcc = bc;
                for (int i = 0; i < bc; i++)
                {
                    fcc ^= txData[3 + i];
                }
                frameToSend[txData.Length] = fcc;
            }

            _serialPort.DiscardInBuffer();
            _serialPort.Write(frameToSend, 0, frameToSend.Length);

            int ack = _serialPort.ReadByte();
            if (ack == -1) return JVMAConstants.MVT_TXRX_NOACK;
            rxData[0] = (byte)ack;

            bool isAllRequest = (txData[0] & JVMAConstants.MVT_CMD_BITS) == JVMAConstants.CMD_AREQ;
            bool hasDataFrame = (ack == JVMAConstants.MVT_ACK_ACK1 || ack == JVMAConstants.MVT_ACK_ACK3) && isAllRequest ||
                                (ack == JVMAConstants.MVT_ACK_ACK2 || ack == JVMAConstants.MVT_ACK_ACK3) && !isAllRequest;

            if (!hasDataFrame) return 1;

            int rxSize = _serialPort.ReadByte();
            if (rxSize == -1) return JVMAConstants.MVT_TXRX_NOACK;
            rxData[1] = (byte)rxSize;

            byte[] dataAndFcc = new byte[rxSize + 1];
            int totalBytesRead = 0;
            while (totalBytesRead < dataAndFcc.Length)
            {
                int bytesRead = _serialPort.Read(dataAndFcc, totalBytesRead, dataAndFcc.Length - totalBytesRead);
                if (bytesRead == 0) throw new TimeoutException();
                totalBytesRead += bytesRead;
            }

            byte calculatedFcc = (byte)rxSize;
            for (int i = 0; i < rxSize; i++)
            {
                rxData[i + 2] = dataAndFcc[i];
                calculatedFcc ^= dataAndFcc[i];
            }

            if (calculatedFcc != dataAndFcc[rxSize]) return JVMAConstants.MVT_TXRX_FCCFAIL;

            return rxSize + 2;
        }
        catch (TimeoutException)
        {
            return JVMAConstants.MVT_TXRX_NOACK;
        }
        catch (Exception)
        {
            return -1;
        }
    }
}

// Copyright 2023 OCT Co.,Ltd. All Rights Reserved.
